//
// Copyright (C) 2006, NinjaTrader LLC <ninjatrader@ninjatrader.com>.
// NinjaTrader reserves the right to modify or overwrite this NinjaScript component with each release.
//

#region Using declarations
using System;
using System.ComponentModel;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private PowerEminiDynamicRangeIndicator[] cachePowerEminiDynamicRangeIndicator = null;

        private static PowerEminiDynamicRangeIndicator checkPowerEminiDynamicRangeIndicator = new PowerEminiDynamicRangeIndicator();

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public PowerEminiDynamicRangeIndicator PowerEminiDynamicRangeIndicator(Color alertLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle alertLineStyle, int alertLineWidth, Color dynamicRangeHighColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeHighStyle, int dynamicRangeHighWidth, Color dynamicRangeLowColor, int dynamicRangeLowWidth, Color dynamicRangeMidlineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeMidlineStyle, int dynamicRangeMidlineWidth, Color dynamicRangeShading, bool dynamicTargets, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamiucRangeLowStyle, bool heikenAshiOn, bool keyOffBsrClose, Color longBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle longBarrierLineStyle, int longBarrierLineWidth, Color microBarriersColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle microBarriersStyle, int microBarriersWidth, bool parabolicStopExitsOn, double parabolicStopThreshold, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiSystemEnum powerEminiSystem, Color shortBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle shortBarrierLineStyle, int shortBarrierLineWidth, int statusFontSize, Color tradeBarrierAlertColor, int tradeBarrierAlertSize, Color trailingStopColor, bool trailingStopOn, int trailingStopWidth)
        {
            return PowerEminiDynamicRangeIndicator(Input, alertLineColor, alertLineStyle, alertLineWidth, dynamicRangeHighColor, dynamicRangeHighStyle, dynamicRangeHighWidth, dynamicRangeLowColor, dynamicRangeLowWidth, dynamicRangeMidlineColor, dynamicRangeMidlineStyle, dynamicRangeMidlineWidth, dynamicRangeShading, dynamicTargets, dynamiucRangeLowStyle, heikenAshiOn, keyOffBsrClose, longBarrierLineColor, longBarrierLineStyle, longBarrierLineWidth, microBarriersColor, microBarriersStyle, microBarriersWidth, parabolicStopExitsOn, parabolicStopThreshold, powerEminiSystem, shortBarrierLineColor, shortBarrierLineStyle, shortBarrierLineWidth, statusFontSize, tradeBarrierAlertColor, tradeBarrierAlertSize, trailingStopColor, trailingStopOn, trailingStopWidth);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public PowerEminiDynamicRangeIndicator PowerEminiDynamicRangeIndicator(Data.IDataSeries input, Color alertLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle alertLineStyle, int alertLineWidth, Color dynamicRangeHighColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeHighStyle, int dynamicRangeHighWidth, Color dynamicRangeLowColor, int dynamicRangeLowWidth, Color dynamicRangeMidlineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeMidlineStyle, int dynamicRangeMidlineWidth, Color dynamicRangeShading, bool dynamicTargets, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamiucRangeLowStyle, bool heikenAshiOn, bool keyOffBsrClose, Color longBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle longBarrierLineStyle, int longBarrierLineWidth, Color microBarriersColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle microBarriersStyle, int microBarriersWidth, bool parabolicStopExitsOn, double parabolicStopThreshold, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiSystemEnum powerEminiSystem, Color shortBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle shortBarrierLineStyle, int shortBarrierLineWidth, int statusFontSize, Color tradeBarrierAlertColor, int tradeBarrierAlertSize, Color trailingStopColor, bool trailingStopOn, int trailingStopWidth)
        {
            if (cachePowerEminiDynamicRangeIndicator != null)
                for (int idx = 0; idx < cachePowerEminiDynamicRangeIndicator.Length; idx++)
                    if (cachePowerEminiDynamicRangeIndicator[idx].AlertLineColor == alertLineColor && cachePowerEminiDynamicRangeIndicator[idx].AlertLineStyle == alertLineStyle && cachePowerEminiDynamicRangeIndicator[idx].AlertLineWidth == alertLineWidth && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeHighColor == dynamicRangeHighColor && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeHighStyle == dynamicRangeHighStyle && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeHighWidth == dynamicRangeHighWidth && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeLowColor == dynamicRangeLowColor && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeLowWidth == dynamicRangeLowWidth && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeMidlineColor == dynamicRangeMidlineColor && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeMidlineStyle == dynamicRangeMidlineStyle && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeMidlineWidth == dynamicRangeMidlineWidth && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeShading == dynamicRangeShading && cachePowerEminiDynamicRangeIndicator[idx].DynamicTargets == dynamicTargets && cachePowerEminiDynamicRangeIndicator[idx].DynamiucRangeLowStyle == dynamiucRangeLowStyle && cachePowerEminiDynamicRangeIndicator[idx].HeikenAshiOn == heikenAshiOn && cachePowerEminiDynamicRangeIndicator[idx].KeyOffBsrClose == keyOffBsrClose && cachePowerEminiDynamicRangeIndicator[idx].LongBarrierLineColor == longBarrierLineColor && cachePowerEminiDynamicRangeIndicator[idx].LongBarrierLineStyle == longBarrierLineStyle && cachePowerEminiDynamicRangeIndicator[idx].LongBarrierLineWidth == longBarrierLineWidth && cachePowerEminiDynamicRangeIndicator[idx].MicroBarriersColor == microBarriersColor && cachePowerEminiDynamicRangeIndicator[idx].MicroBarriersStyle == microBarriersStyle && cachePowerEminiDynamicRangeIndicator[idx].MicroBarriersWidth == microBarriersWidth && cachePowerEminiDynamicRangeIndicator[idx].ParabolicStopExitsOn == parabolicStopExitsOn && Math.Abs(cachePowerEminiDynamicRangeIndicator[idx].ParabolicStopThreshold - parabolicStopThreshold) <= double.Epsilon && cachePowerEminiDynamicRangeIndicator[idx].PowerEminiSystem == powerEminiSystem && cachePowerEminiDynamicRangeIndicator[idx].ShortBarrierLineColor == shortBarrierLineColor && cachePowerEminiDynamicRangeIndicator[idx].ShortBarrierLineStyle == shortBarrierLineStyle && cachePowerEminiDynamicRangeIndicator[idx].ShortBarrierLineWidth == shortBarrierLineWidth && cachePowerEminiDynamicRangeIndicator[idx].StatusFontSize == statusFontSize && cachePowerEminiDynamicRangeIndicator[idx].TradeBarrierAlertColor == tradeBarrierAlertColor && cachePowerEminiDynamicRangeIndicator[idx].TradeBarrierAlertSize == tradeBarrierAlertSize && cachePowerEminiDynamicRangeIndicator[idx].TrailingStopColor == trailingStopColor && cachePowerEminiDynamicRangeIndicator[idx].TrailingStopOn == trailingStopOn && cachePowerEminiDynamicRangeIndicator[idx].TrailingStopWidth == trailingStopWidth && cachePowerEminiDynamicRangeIndicator[idx].EqualsInput(input))
                        return cachePowerEminiDynamicRangeIndicator[idx];

            lock (checkPowerEminiDynamicRangeIndicator)
            {
                checkPowerEminiDynamicRangeIndicator.AlertLineColor = alertLineColor;
                alertLineColor = checkPowerEminiDynamicRangeIndicator.AlertLineColor;
                checkPowerEminiDynamicRangeIndicator.AlertLineStyle = alertLineStyle;
                alertLineStyle = checkPowerEminiDynamicRangeIndicator.AlertLineStyle;
                checkPowerEminiDynamicRangeIndicator.AlertLineWidth = alertLineWidth;
                alertLineWidth = checkPowerEminiDynamicRangeIndicator.AlertLineWidth;
                checkPowerEminiDynamicRangeIndicator.DynamicRangeHighColor = dynamicRangeHighColor;
                dynamicRangeHighColor = checkPowerEminiDynamicRangeIndicator.DynamicRangeHighColor;
                checkPowerEminiDynamicRangeIndicator.DynamicRangeHighStyle = dynamicRangeHighStyle;
                dynamicRangeHighStyle = checkPowerEminiDynamicRangeIndicator.DynamicRangeHighStyle;
                checkPowerEminiDynamicRangeIndicator.DynamicRangeHighWidth = dynamicRangeHighWidth;
                dynamicRangeHighWidth = checkPowerEminiDynamicRangeIndicator.DynamicRangeHighWidth;
                checkPowerEminiDynamicRangeIndicator.DynamicRangeLowColor = dynamicRangeLowColor;
                dynamicRangeLowColor = checkPowerEminiDynamicRangeIndicator.DynamicRangeLowColor;
                checkPowerEminiDynamicRangeIndicator.DynamicRangeLowWidth = dynamicRangeLowWidth;
                dynamicRangeLowWidth = checkPowerEminiDynamicRangeIndicator.DynamicRangeLowWidth;
                checkPowerEminiDynamicRangeIndicator.DynamicRangeMidlineColor = dynamicRangeMidlineColor;
                dynamicRangeMidlineColor = checkPowerEminiDynamicRangeIndicator.DynamicRangeMidlineColor;
                checkPowerEminiDynamicRangeIndicator.DynamicRangeMidlineStyle = dynamicRangeMidlineStyle;
                dynamicRangeMidlineStyle = checkPowerEminiDynamicRangeIndicator.DynamicRangeMidlineStyle;
                checkPowerEminiDynamicRangeIndicator.DynamicRangeMidlineWidth = dynamicRangeMidlineWidth;
                dynamicRangeMidlineWidth = checkPowerEminiDynamicRangeIndicator.DynamicRangeMidlineWidth;
                checkPowerEminiDynamicRangeIndicator.DynamicRangeShading = dynamicRangeShading;
                dynamicRangeShading = checkPowerEminiDynamicRangeIndicator.DynamicRangeShading;
                checkPowerEminiDynamicRangeIndicator.DynamicTargets = dynamicTargets;
                dynamicTargets = checkPowerEminiDynamicRangeIndicator.DynamicTargets;
                checkPowerEminiDynamicRangeIndicator.DynamiucRangeLowStyle = dynamiucRangeLowStyle;
                dynamiucRangeLowStyle = checkPowerEminiDynamicRangeIndicator.DynamiucRangeLowStyle;
                checkPowerEminiDynamicRangeIndicator.HeikenAshiOn = heikenAshiOn;
                heikenAshiOn = checkPowerEminiDynamicRangeIndicator.HeikenAshiOn;
                checkPowerEminiDynamicRangeIndicator.KeyOffBsrClose = keyOffBsrClose;
                keyOffBsrClose = checkPowerEminiDynamicRangeIndicator.KeyOffBsrClose;
                checkPowerEminiDynamicRangeIndicator.LongBarrierLineColor = longBarrierLineColor;
                longBarrierLineColor = checkPowerEminiDynamicRangeIndicator.LongBarrierLineColor;
                checkPowerEminiDynamicRangeIndicator.LongBarrierLineStyle = longBarrierLineStyle;
                longBarrierLineStyle = checkPowerEminiDynamicRangeIndicator.LongBarrierLineStyle;
                checkPowerEminiDynamicRangeIndicator.LongBarrierLineWidth = longBarrierLineWidth;
                longBarrierLineWidth = checkPowerEminiDynamicRangeIndicator.LongBarrierLineWidth;
                checkPowerEminiDynamicRangeIndicator.MicroBarriersColor = microBarriersColor;
                microBarriersColor = checkPowerEminiDynamicRangeIndicator.MicroBarriersColor;
                checkPowerEminiDynamicRangeIndicator.MicroBarriersStyle = microBarriersStyle;
                microBarriersStyle = checkPowerEminiDynamicRangeIndicator.MicroBarriersStyle;
                checkPowerEminiDynamicRangeIndicator.MicroBarriersWidth = microBarriersWidth;
                microBarriersWidth = checkPowerEminiDynamicRangeIndicator.MicroBarriersWidth;
                checkPowerEminiDynamicRangeIndicator.ParabolicStopExitsOn = parabolicStopExitsOn;
                parabolicStopExitsOn = checkPowerEminiDynamicRangeIndicator.ParabolicStopExitsOn;
                checkPowerEminiDynamicRangeIndicator.ParabolicStopThreshold = parabolicStopThreshold;
                parabolicStopThreshold = checkPowerEminiDynamicRangeIndicator.ParabolicStopThreshold;
                checkPowerEminiDynamicRangeIndicator.PowerEminiSystem = powerEminiSystem;
                powerEminiSystem = checkPowerEminiDynamicRangeIndicator.PowerEminiSystem;
                checkPowerEminiDynamicRangeIndicator.ShortBarrierLineColor = shortBarrierLineColor;
                shortBarrierLineColor = checkPowerEminiDynamicRangeIndicator.ShortBarrierLineColor;
                checkPowerEminiDynamicRangeIndicator.ShortBarrierLineStyle = shortBarrierLineStyle;
                shortBarrierLineStyle = checkPowerEminiDynamicRangeIndicator.ShortBarrierLineStyle;
                checkPowerEminiDynamicRangeIndicator.ShortBarrierLineWidth = shortBarrierLineWidth;
                shortBarrierLineWidth = checkPowerEminiDynamicRangeIndicator.ShortBarrierLineWidth;
                checkPowerEminiDynamicRangeIndicator.StatusFontSize = statusFontSize;
                statusFontSize = checkPowerEminiDynamicRangeIndicator.StatusFontSize;
                checkPowerEminiDynamicRangeIndicator.TradeBarrierAlertColor = tradeBarrierAlertColor;
                tradeBarrierAlertColor = checkPowerEminiDynamicRangeIndicator.TradeBarrierAlertColor;
                checkPowerEminiDynamicRangeIndicator.TradeBarrierAlertSize = tradeBarrierAlertSize;
                tradeBarrierAlertSize = checkPowerEminiDynamicRangeIndicator.TradeBarrierAlertSize;
                checkPowerEminiDynamicRangeIndicator.TrailingStopColor = trailingStopColor;
                trailingStopColor = checkPowerEminiDynamicRangeIndicator.TrailingStopColor;
                checkPowerEminiDynamicRangeIndicator.TrailingStopOn = trailingStopOn;
                trailingStopOn = checkPowerEminiDynamicRangeIndicator.TrailingStopOn;
                checkPowerEminiDynamicRangeIndicator.TrailingStopWidth = trailingStopWidth;
                trailingStopWidth = checkPowerEminiDynamicRangeIndicator.TrailingStopWidth;

                if (cachePowerEminiDynamicRangeIndicator != null)
                    for (int idx = 0; idx < cachePowerEminiDynamicRangeIndicator.Length; idx++)
                        if (cachePowerEminiDynamicRangeIndicator[idx].AlertLineColor == alertLineColor && cachePowerEminiDynamicRangeIndicator[idx].AlertLineStyle == alertLineStyle && cachePowerEminiDynamicRangeIndicator[idx].AlertLineWidth == alertLineWidth && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeHighColor == dynamicRangeHighColor && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeHighStyle == dynamicRangeHighStyle && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeHighWidth == dynamicRangeHighWidth && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeLowColor == dynamicRangeLowColor && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeLowWidth == dynamicRangeLowWidth && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeMidlineColor == dynamicRangeMidlineColor && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeMidlineStyle == dynamicRangeMidlineStyle && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeMidlineWidth == dynamicRangeMidlineWidth && cachePowerEminiDynamicRangeIndicator[idx].DynamicRangeShading == dynamicRangeShading && cachePowerEminiDynamicRangeIndicator[idx].DynamicTargets == dynamicTargets && cachePowerEminiDynamicRangeIndicator[idx].DynamiucRangeLowStyle == dynamiucRangeLowStyle && cachePowerEminiDynamicRangeIndicator[idx].HeikenAshiOn == heikenAshiOn && cachePowerEminiDynamicRangeIndicator[idx].KeyOffBsrClose == keyOffBsrClose && cachePowerEminiDynamicRangeIndicator[idx].LongBarrierLineColor == longBarrierLineColor && cachePowerEminiDynamicRangeIndicator[idx].LongBarrierLineStyle == longBarrierLineStyle && cachePowerEminiDynamicRangeIndicator[idx].LongBarrierLineWidth == longBarrierLineWidth && cachePowerEminiDynamicRangeIndicator[idx].MicroBarriersColor == microBarriersColor && cachePowerEminiDynamicRangeIndicator[idx].MicroBarriersStyle == microBarriersStyle && cachePowerEminiDynamicRangeIndicator[idx].MicroBarriersWidth == microBarriersWidth && cachePowerEminiDynamicRangeIndicator[idx].ParabolicStopExitsOn == parabolicStopExitsOn && Math.Abs(cachePowerEminiDynamicRangeIndicator[idx].ParabolicStopThreshold - parabolicStopThreshold) <= double.Epsilon && cachePowerEminiDynamicRangeIndicator[idx].PowerEminiSystem == powerEminiSystem && cachePowerEminiDynamicRangeIndicator[idx].ShortBarrierLineColor == shortBarrierLineColor && cachePowerEminiDynamicRangeIndicator[idx].ShortBarrierLineStyle == shortBarrierLineStyle && cachePowerEminiDynamicRangeIndicator[idx].ShortBarrierLineWidth == shortBarrierLineWidth && cachePowerEminiDynamicRangeIndicator[idx].StatusFontSize == statusFontSize && cachePowerEminiDynamicRangeIndicator[idx].TradeBarrierAlertColor == tradeBarrierAlertColor && cachePowerEminiDynamicRangeIndicator[idx].TradeBarrierAlertSize == tradeBarrierAlertSize && cachePowerEminiDynamicRangeIndicator[idx].TrailingStopColor == trailingStopColor && cachePowerEminiDynamicRangeIndicator[idx].TrailingStopOn == trailingStopOn && cachePowerEminiDynamicRangeIndicator[idx].TrailingStopWidth == trailingStopWidth && cachePowerEminiDynamicRangeIndicator[idx].EqualsInput(input))
                            return cachePowerEminiDynamicRangeIndicator[idx];

                PowerEminiDynamicRangeIndicator indicator = new PowerEminiDynamicRangeIndicator();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.AlertLineColor = alertLineColor;
                indicator.AlertLineStyle = alertLineStyle;
                indicator.AlertLineWidth = alertLineWidth;
                indicator.DynamicRangeHighColor = dynamicRangeHighColor;
                indicator.DynamicRangeHighStyle = dynamicRangeHighStyle;
                indicator.DynamicRangeHighWidth = dynamicRangeHighWidth;
                indicator.DynamicRangeLowColor = dynamicRangeLowColor;
                indicator.DynamicRangeLowWidth = dynamicRangeLowWidth;
                indicator.DynamicRangeMidlineColor = dynamicRangeMidlineColor;
                indicator.DynamicRangeMidlineStyle = dynamicRangeMidlineStyle;
                indicator.DynamicRangeMidlineWidth = dynamicRangeMidlineWidth;
                indicator.DynamicRangeShading = dynamicRangeShading;
                indicator.DynamicTargets = dynamicTargets;
                indicator.DynamiucRangeLowStyle = dynamiucRangeLowStyle;
                indicator.HeikenAshiOn = heikenAshiOn;
                indicator.KeyOffBsrClose = keyOffBsrClose;
                indicator.LongBarrierLineColor = longBarrierLineColor;
                indicator.LongBarrierLineStyle = longBarrierLineStyle;
                indicator.LongBarrierLineWidth = longBarrierLineWidth;
                indicator.MicroBarriersColor = microBarriersColor;
                indicator.MicroBarriersStyle = microBarriersStyle;
                indicator.MicroBarriersWidth = microBarriersWidth;
                indicator.ParabolicStopExitsOn = parabolicStopExitsOn;
                indicator.ParabolicStopThreshold = parabolicStopThreshold;
                indicator.PowerEminiSystem = powerEminiSystem;
                indicator.ShortBarrierLineColor = shortBarrierLineColor;
                indicator.ShortBarrierLineStyle = shortBarrierLineStyle;
                indicator.ShortBarrierLineWidth = shortBarrierLineWidth;
                indicator.StatusFontSize = statusFontSize;
                indicator.TradeBarrierAlertColor = tradeBarrierAlertColor;
                indicator.TradeBarrierAlertSize = tradeBarrierAlertSize;
                indicator.TrailingStopColor = trailingStopColor;
                indicator.TrailingStopOn = trailingStopOn;
                indicator.TrailingStopWidth = trailingStopWidth;
                Indicators.Add(indicator);
                indicator.SetUp();

                PowerEminiDynamicRangeIndicator[] tmp = new PowerEminiDynamicRangeIndicator[cachePowerEminiDynamicRangeIndicator == null ? 1 : cachePowerEminiDynamicRangeIndicator.Length + 1];
                if (cachePowerEminiDynamicRangeIndicator != null)
                    cachePowerEminiDynamicRangeIndicator.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cachePowerEminiDynamicRangeIndicator = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PowerEminiDynamicRangeIndicator PowerEminiDynamicRangeIndicator(Color alertLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle alertLineStyle, int alertLineWidth, Color dynamicRangeHighColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeHighStyle, int dynamicRangeHighWidth, Color dynamicRangeLowColor, int dynamicRangeLowWidth, Color dynamicRangeMidlineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeMidlineStyle, int dynamicRangeMidlineWidth, Color dynamicRangeShading, bool dynamicTargets, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamiucRangeLowStyle, bool heikenAshiOn, bool keyOffBsrClose, Color longBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle longBarrierLineStyle, int longBarrierLineWidth, Color microBarriersColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle microBarriersStyle, int microBarriersWidth, bool parabolicStopExitsOn, double parabolicStopThreshold, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiSystemEnum powerEminiSystem, Color shortBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle shortBarrierLineStyle, int shortBarrierLineWidth, int statusFontSize, Color tradeBarrierAlertColor, int tradeBarrierAlertSize, Color trailingStopColor, bool trailingStopOn, int trailingStopWidth)
        {
            return _indicator.PowerEminiDynamicRangeIndicator(Input, alertLineColor, alertLineStyle, alertLineWidth, dynamicRangeHighColor, dynamicRangeHighStyle, dynamicRangeHighWidth, dynamicRangeLowColor, dynamicRangeLowWidth, dynamicRangeMidlineColor, dynamicRangeMidlineStyle, dynamicRangeMidlineWidth, dynamicRangeShading, dynamicTargets, dynamiucRangeLowStyle, heikenAshiOn, keyOffBsrClose, longBarrierLineColor, longBarrierLineStyle, longBarrierLineWidth, microBarriersColor, microBarriersStyle, microBarriersWidth, parabolicStopExitsOn, parabolicStopThreshold, powerEminiSystem, shortBarrierLineColor, shortBarrierLineStyle, shortBarrierLineWidth, statusFontSize, tradeBarrierAlertColor, tradeBarrierAlertSize, trailingStopColor, trailingStopOn, trailingStopWidth);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.PowerEminiDynamicRangeIndicator PowerEminiDynamicRangeIndicator(Data.IDataSeries input, Color alertLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle alertLineStyle, int alertLineWidth, Color dynamicRangeHighColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeHighStyle, int dynamicRangeHighWidth, Color dynamicRangeLowColor, int dynamicRangeLowWidth, Color dynamicRangeMidlineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeMidlineStyle, int dynamicRangeMidlineWidth, Color dynamicRangeShading, bool dynamicTargets, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamiucRangeLowStyle, bool heikenAshiOn, bool keyOffBsrClose, Color longBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle longBarrierLineStyle, int longBarrierLineWidth, Color microBarriersColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle microBarriersStyle, int microBarriersWidth, bool parabolicStopExitsOn, double parabolicStopThreshold, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiSystemEnum powerEminiSystem, Color shortBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle shortBarrierLineStyle, int shortBarrierLineWidth, int statusFontSize, Color tradeBarrierAlertColor, int tradeBarrierAlertSize, Color trailingStopColor, bool trailingStopOn, int trailingStopWidth)
        {
            return _indicator.PowerEminiDynamicRangeIndicator(input, alertLineColor, alertLineStyle, alertLineWidth, dynamicRangeHighColor, dynamicRangeHighStyle, dynamicRangeHighWidth, dynamicRangeLowColor, dynamicRangeLowWidth, dynamicRangeMidlineColor, dynamicRangeMidlineStyle, dynamicRangeMidlineWidth, dynamicRangeShading, dynamicTargets, dynamiucRangeLowStyle, heikenAshiOn, keyOffBsrClose, longBarrierLineColor, longBarrierLineStyle, longBarrierLineWidth, microBarriersColor, microBarriersStyle, microBarriersWidth, parabolicStopExitsOn, parabolicStopThreshold, powerEminiSystem, shortBarrierLineColor, shortBarrierLineStyle, shortBarrierLineWidth, statusFontSize, tradeBarrierAlertColor, tradeBarrierAlertSize, trailingStopColor, trailingStopOn, trailingStopWidth);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.PowerEminiDynamicRangeIndicator PowerEminiDynamicRangeIndicator(Color alertLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle alertLineStyle, int alertLineWidth, Color dynamicRangeHighColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeHighStyle, int dynamicRangeHighWidth, Color dynamicRangeLowColor, int dynamicRangeLowWidth, Color dynamicRangeMidlineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeMidlineStyle, int dynamicRangeMidlineWidth, Color dynamicRangeShading, bool dynamicTargets, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamiucRangeLowStyle, bool heikenAshiOn, bool keyOffBsrClose, Color longBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle longBarrierLineStyle, int longBarrierLineWidth, Color microBarriersColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle microBarriersStyle, int microBarriersWidth, bool parabolicStopExitsOn, double parabolicStopThreshold, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiSystemEnum powerEminiSystem, Color shortBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle shortBarrierLineStyle, int shortBarrierLineWidth, int statusFontSize, Color tradeBarrierAlertColor, int tradeBarrierAlertSize, Color trailingStopColor, bool trailingStopOn, int trailingStopWidth)
        {
            return _indicator.PowerEminiDynamicRangeIndicator(Input, alertLineColor, alertLineStyle, alertLineWidth, dynamicRangeHighColor, dynamicRangeHighStyle, dynamicRangeHighWidth, dynamicRangeLowColor, dynamicRangeLowWidth, dynamicRangeMidlineColor, dynamicRangeMidlineStyle, dynamicRangeMidlineWidth, dynamicRangeShading, dynamicTargets, dynamiucRangeLowStyle, heikenAshiOn, keyOffBsrClose, longBarrierLineColor, longBarrierLineStyle, longBarrierLineWidth, microBarriersColor, microBarriersStyle, microBarriersWidth, parabolicStopExitsOn, parabolicStopThreshold, powerEminiSystem, shortBarrierLineColor, shortBarrierLineStyle, shortBarrierLineWidth, statusFontSize, tradeBarrierAlertColor, tradeBarrierAlertSize, trailingStopColor, trailingStopOn, trailingStopWidth);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public Indicator.PowerEminiDynamicRangeIndicator PowerEminiDynamicRangeIndicator(Data.IDataSeries input, Color alertLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle alertLineStyle, int alertLineWidth, Color dynamicRangeHighColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeHighStyle, int dynamicRangeHighWidth, Color dynamicRangeLowColor, int dynamicRangeLowWidth, Color dynamicRangeMidlineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamicRangeMidlineStyle, int dynamicRangeMidlineWidth, Color dynamicRangeShading, bool dynamicTargets, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle dynamiucRangeLowStyle, bool heikenAshiOn, bool keyOffBsrClose, Color longBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle longBarrierLineStyle, int longBarrierLineWidth, Color microBarriersColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle microBarriersStyle, int microBarriersWidth, bool parabolicStopExitsOn, double parabolicStopThreshold, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiSystemEnum powerEminiSystem, Color shortBarrierLineColor, NinjaTrader.Indicator.PowerEminiDynamicRangeIndicator.PowerEminiDashStyle shortBarrierLineStyle, int shortBarrierLineWidth, int statusFontSize, Color tradeBarrierAlertColor, int tradeBarrierAlertSize, Color trailingStopColor, bool trailingStopOn, int trailingStopWidth)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.PowerEminiDynamicRangeIndicator(input, alertLineColor, alertLineStyle, alertLineWidth, dynamicRangeHighColor, dynamicRangeHighStyle, dynamicRangeHighWidth, dynamicRangeLowColor, dynamicRangeLowWidth, dynamicRangeMidlineColor, dynamicRangeMidlineStyle, dynamicRangeMidlineWidth, dynamicRangeShading, dynamicTargets, dynamiucRangeLowStyle, heikenAshiOn, keyOffBsrClose, longBarrierLineColor, longBarrierLineStyle, longBarrierLineWidth, microBarriersColor, microBarriersStyle, microBarriersWidth, parabolicStopExitsOn, parabolicStopThreshold, powerEminiSystem, shortBarrierLineColor, shortBarrierLineStyle, shortBarrierLineWidth, statusFontSize, tradeBarrierAlertColor, tradeBarrierAlertSize, trailingStopColor, trailingStopOn, trailingStopWidth);
        }
    }
}
#endregion
